(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8588,        323]*)
(*NotebookOutlinePosition[      9490,        353]*)
(*  CellTagsIndexPosition[      9446,        349]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Bernoulli Equations", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Bernoulli differential equations have the form ",
  StyleBox["y' + p[x]y == q[x] y^n", "Input"],
  ", where n is any real number. In the cases n == 0 and n == 1 the \
differential equation is linear, and these special methods are not needed.\n\n\
In this notebook, enter your Bernoulli differential equation as ",
  StyleBox["BE[x_,y_]:=equation",
    FontWeight->"Bold"],
  ". Then execute the lines in the notebook one at a time manually, or using \
",
  StyleBox["Evaluate Notebook",
    FontWeight->"Bold"],
  " under the ",
  StyleBox["K",
    FontWeight->"Bold"],
  StyleBox["ernel",
    FontWeight->"Bold"],
  " menu item. In either event",
  StyleBox[" it is wise to manually execute the steps through the \
verification that the equation is Bernoulli",
    FontVariations->{"Underline"->True}],
  " before using  ",
  StyleBox["Evaluate Notebook.\n\n",
    FontWeight->"Bold"],
  "Notice how the steps parallel the theory."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Define the equation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[BE, BNum, x, y, w, s, LeftSide, yp, SolnW]\), "\n", 
    \(BE[x_, y_] := \[PartialD]\_x y[x] - y[x] == E\^x\/y[x]\)}], "Input",
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Verify the equation"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(BE[x, y]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-y[x]\), "+", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], 
      "==", \(\[ExponentialE]\^x\/y[x]\)}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Determine the power of y[x]"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(BNum = 
      If[FreeQ[\(BE[x, y]\)\[LeftDoubleBracket]2\[RightDoubleBracket], y], 
        0, \(\(BE[x, y]\)\[LeftDoubleBracket]2\[RightDoubleBracket] //. 
            c_. \ y[x]\^n_ \[Rule] n\) /. c_. \ y[x] \[Rule] 1]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-1\)\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Verify that the equation is of Bernoulli type."], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"If the equation is linear and not of Bernoulli type, it should be solved by \
linear methods. (The notebook works when n == 0, but not when n == 1.)"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(If[BNum == 1 || BNum == 0, 
      Print["\<The equation is linear. Use linear methods.\>"], 
      Print["\<The equation is of Bernoulli type.\>"]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \("The equation is of Bernoulli type."\)], "Print"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Declare & make the substitution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Declare the substitution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[w]\), "\n", 
    \(w[x_] == y[x]\^\(1 - BNum\)\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(w[x_] == y[x]\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Make the substitution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"yp", "=", 
      RowBox[{"Solve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["w", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], 
            "==", \(\[PartialD]\_x y[x]\^\(1 - BNum\)\)}], ",", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          FractionBox[
            RowBox[{
              SuperscriptBox["w", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], \(2\ y[x]\)]}], 
        "}"}], "}"}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LeftSide = \((#1\/y[x]\^BNum &)\) /@ \((\(BE[x, y] /. 
              yp\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. 
            a_ == b_ \[Rule] a - b)\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(-\[ExponentialE]\^x\), "-", \(y[x]\^2\), "+", 
      FractionBox[
        RowBox[{
          SuperscriptBox["w", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "2"]}]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Obtain the linear operator"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x_, w_] = LeftSide /. y[x]\^\(1 - BNum\) \[Rule] w[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(-\[ExponentialE]\^x\), "-", \(w[x]\), "+", 
      FractionBox[
        RowBox[{
          SuperscriptBox["w", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "2"]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solve the linear differential equation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(SolnW = DSolve[L[x, w] == 0, w[x], x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{w[
            x] \[Rule] \(-2\)\ \[ExponentialE]\^x + \[ExponentialE]\^\(2\ x\)\
\ C[1]}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Simplify the solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = 
      Simplify[\((w[x] /. \
SolnW\[LeftDoubleBracket]1\[RightDoubleBracket])\)\^\(1\/\(1 - BNum\)\)]\)], \
"Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\@\(\[ExponentialE]\^x\ \((\(-2\) + \[ExponentialE]\^x\ C[1])\)\)\)], \
"Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check the solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[BE[x, s]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{559, 598},
WindowMargins->{{64, Automatic}, {Automatic, 4}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 87, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1866, 57, 1012, 27, 194, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2903, 88, 97, 2, 56, "Section",
  Evaluatable->False],
Cell[3003, 92, 181, 3, 63, "Input"],

Cell[CellGroupData[{
Cell[3209, 99, 100, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3334, 105, 68, 2, 27, "Input"],
Cell[3405, 109, 229, 6, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3683, 121, 108, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3816, 127, 280, 5, 43, "Input"],
Cell[4099, 134, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4200, 142, 124, 2, 36, "Section",
  Evaluatable->False],
Cell[4327, 146, 227, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4579, 155, 207, 4, 59, "Input"],
Cell[4789, 161, 69, 1, 23, "Print"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4907, 168, 109, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5041, 174, 105, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5171, 180, 114, 3, 45, "Input"],
Cell[5288, 185, 50, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5387, 192, 102, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5514, 198, 462, 12, 31, "Input"],
Cell[5979, 212, 399, 11, 44, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6415, 228, 217, 4, 44, "Input"],
Cell[6635, 234, 226, 5, 42, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6922, 246, 104, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7051, 252, 115, 2, 29, "Input"],
Cell[7169, 256, 223, 5, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7441, 267, 116, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7582, 273, 97, 2, 27, "Input"],
Cell[7682, 277, 126, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7845, 285, 102, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7972, 291, 171, 5, 37, "Input"],
Cell[8146, 298, 101, 2, 30, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8308, 307, 96, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8429, 313, 78, 2, 27, "Input"],
Cell[8510, 317, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

